// VisaApiDemoDlg.h : header file
//

#if !defined(AFX_VISAAPIDEMODLG_H__F1D78E07_E7CB_11D4_9C5F_009027ED2E9A__INCLUDED_)
#define AFX_VISAAPIDEMODLG_H__F1D78E07_E7CB_11D4_9C5F_009027ED2E9A__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

/////////////////////////////////////////////////////////////////////////////
// CVisaApiDemoDlg dialog

class CVisaApiDemoDlg : public CDialog
{
// Construction
public:
	CVisaApiDemoDlg(CWnd* pParent = NULL);	// standard constructor

// Dialog Data
	//{{AFX_DATA(CVisaApiDemoDlg)
	enum { IDD = IDD_VISAAPIDEMO_DIALOG };
	CButton	m_btnParseRsrc;
	CButton	m_btnFindRsrc;
	CButton	m_btnClear;
	CButton	m_btnReadAsync;
	CButton	m_btnWriteAsync;
	CButton	m_btnRead;
	CButton	m_btnWrite;
	CButton	m_btnAttributes;
	CButton	m_btnIOComplete;
	CEdit	m_editViStatus;
	CEdit	m_mleInfo;
	CButton	m_btnOpenClose;
	CButton	m_btnOpenCloseDefRM;
	CString	m_strResourceName;
	BOOL	m_bExclusiveLock;
	BOOL	m_bLoadConfig;
	UINT	m_dwTimeout;
	CString	m_strTestParameter;
	//}}AFX_DATA

	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CVisaApiDemoDlg)
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);	// DDX/DDV support
	//}}AFX_VIRTUAL

// Implementation
protected:
	HICON m_hIcon;

	// UI and other helper methods
	void UpdateStatus();
	void UpdateButtons();
	void Wait4IOCompletion(ViPUInt32 pcbIO = NULL);
	void PeakMessages();

	// Attribute Explorer dialog instance
	CVisaAttributeExplorer* m_pobjAttribExplorer;
	// Support methods for modeless attribute dialog
public:
	void AttributeExplorerClosing();

	bool GetVisaAttribute(ViAttr attribute, void* attrState);

	void SetVisaAttribute(ViAttr attribute, ViAttrState attrState);


protected:
	// VISA specific stuff
	ViStatus m_stat;			// status returned by last operator invocation
	ViSession m_viDefRM;		// default resource manager session
	ViSession m_viSession;		// currently open session
	ViJobId m_idJob;			// ID of asychronous job
	bool m_bIOComplete;			// track I/O completion event hooking

	// Generated message map functions
	//{{AFX_MSG(CVisaApiDemoDlg)
	virtual BOOL OnInitDialog();
	afx_msg void OnSysCommand(UINT nID, LPARAM lParam);
	afx_msg void OnPaint();
	afx_msg HCURSOR OnQueryDragIcon();
	afx_msg void OnOpenCloseDefRm();
	afx_msg void OnOpenClose();
	afx_msg void OnParseRsrc();
	afx_msg void OnViWrite();
	afx_msg void OnViRead();
	afx_msg void OnFindRsrc();
	afx_msg void OnViWriteAsync();
	afx_msg void OnViReadAsync();
	afx_msg void OnEventIoCompleteCallback();
	afx_msg void OnAttributes();
	afx_msg void OnViClear();
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

//{{AFX_INSERT_LOCATION}}
// Microsoft Visual C++ will insert additional declarations immediately before the previous line.

#endif // !defined(AFX_VISAAPIDEMODLG_H__F1D78E07_E7CB_11D4_9C5F_009027ED2E9A__INCLUDED_)
